/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime;

import filenet.vw.api.VWException;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWIndexDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWMilestoneDefinition;
import filenet.vw.api.VWMilestoneElement;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWProcess;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueQuery;
import filenet.vw.api.VWReturnStackElement;
import filenet.vw.api.VWRoster;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWRosterQuery;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWUserInfo;
import filenet.vw.api.VWWorkObject;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowMilestones;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.runtime.VWTrkLaunchStep;
import filenet.vw.toolkit.runtime.VWTrkMap;
import filenet.vw.toolkit.runtime.VWTrkMilestone;
import filenet.vw.toolkit.runtime.VWTrkParticipant;
import filenet.vw.toolkit.runtime.VWTrkRoute;
import filenet.vw.toolkit.runtime.VWTrkStep;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.VWTrkWorkObject;
import filenet.vw.toolkit.runtime.dialog.VWStatusDetailsDialog;
import filenet.vw.toolkit.runtime.resources.VWResource;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWInformationStackDialog;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWPropertyChangeNotifier;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;

public class VWTrkDataModel
implements Runnable,
IVWPropertyChangeListener,
IVWPropertyChangeSource,
ItemListener {
    public static final int INIT_NONE = 0;
    public static final int INIT_FETCHING_WOB = 1;
    public static final int INIT_FETCHING_WORKFLOW_DEFINITION = 2;
    public static final int INIT_STEP_DEFINITION = 3;
    public static final int INIT_HISTORY = 4;
    public static final int INIT_RUNTIME_DATA = 5;
    public static final int INIT_SUCCESS = 6;
    public static final int INIT_FAILED = 7;
    static final int s_workflowInstrSheetId = -2;
    static final int s_trackerInstrSheetId = -7;
    static final int s_delayQueueId = -6;
    static final int s_ISIQueueId = -5;
    static final int s_conductorQueueId = -7;
    public static final int LOCK_NA = 0;
    public static final int LOCK_UNLOCKED = 1;
    public static final int LOCK_TRACKER = 2;
    public static final int LOCK_OTHER_USER = 4;
    public static final int LOCK_SYSTEM = 8;
    public static final int STATUS_NULL = 0;
    public static final int STATUS_IN_PROGRESS = 1;
    public static final int STATUS_OVERDUE = 9;
    public static final int STATUS_REMINDED = 10;
    public static final int STATUS_COMPLETED = 2;
    public static final int STATUS_COMPLETED_ABNORMAL = 3;
    public static final int STATUS_REASSIGNED = 7;
    public static final int STATUS_DELEGATED = 6;
    public static final int STATUS_RETURNED = 8;
    public static final int STAUTS_DELETED = 4;
    public static final int STAUTS_TERMINATED = 5;
    public static final int STATUS_GOTO_SUBMAP = 11;
    public static final int STATUS_EXCEPTION = 12;
    public static final int STATUS_PAST_EXCEPTION = 13;
    private Container m_mainContainer = null;
    private VWSessionInfo m_sessionInfo = null;
    private volatile int m_initState = 0;
    private boolean m_bInitializing = false;
    private volatile String m_initMsgString = "";
    private volatile String m_initSubMsgString = "";
    private volatile boolean m_initThreadWaiting = false;
    private volatile boolean m_getMsgThreadWating = false;
    private Object m_updatingInitMsg = new Object();
    private Object m_semaphore = new Object();
    private Object m_trackerMode = new Object();
    private boolean m_bSync = false;
    private String m_wobNumber = null;
    private VWWorkObject m_initialWorkObject = null;
    private String m_initialTracker = null;
    private boolean m_b41Workflow = false;
    private int m_initialMapId = -1;
    private int m_initialStepId = -1;
    private boolean m_bRemoveInitialTracker = false;
    private int m_preferredTrackerMode = 0;
    private boolean m_bTracker = false;
    private VWParticipant m_currentUser = null;
    private String m_workflowNumber = null;
    private String m_queueName = null;
    private String m_workClassName = null;
    private String m_docSpec = null;
    private VWProcess m_process = null;
    private VWWorkflowDefinition m_workflowDefinition = null;
    private int m_mainMapId = -2;
    private Vector m_maps = new Vector();
    private VWTrkMap m_mainMap = null;
    private VWTrkMap m_selectedMap = null;
    private Vector m_milestones = new Vector();
    private VWFieldDefinition[] m_fieldDefinitions = null;
    private VWWorkObject m_rootWorkObject = null;
    private Vector m_stepWorkObjects = null;
    private Vector m_trackerWorkObjects = new Vector();
    private Vector m_exceptionWorkObjects = new Vector();
    private VWMapNode m_launchStep = null;
    private Date m_launchDate = null;
    private Date m_completionDate = null;
    private VWParticipant m_originator = null;
    private String m_subject = null;
    private String m_baseWorkClass = null;
    private String m_rosterName = null;
    private String m_eventLogName = null;
    private String m_name = null;
    private String m_tag = null;
    private Vector m_stepsChanged = null;
    private int m_propertyChangeType;
    private boolean m_bNeedRefresh = false;
    private boolean m_bRefreshing = false;
    private VWStatusDetailsDialog m_statusDetailsDialog = null;
    private VWInformationStackDialog m_informationStackDialog = null;
    private boolean m_bCallStepEnabled = true;

    public boolean isCallStepEnabled() {
        if (this.m_bCallStepEnabled && !this.isInitializing() && (this.m_maps == null || this.m_maps.size() <= 1)) {
            this.m_bCallStepEnabled = false;
        }
        return this.m_bCallStepEnabled;
    }

    public VWTrkDataModel(Container container, VWSessionInfo sessionInfo, String queueName, String wobNumber) throws Exception {
        this.m_mainContainer = container;
        this.m_sessionInfo = sessionInfo;
        this.m_wobNumber = wobNumber;
        this.m_queueName = queueName;
        Thread t = new Thread(this);
        t.start();
    }

    public void run() {
        try {
            this.initialize();
        }
        catch (Exception e) {
            VWDebug.logException(e);
            this.m_initState = 7;
            this.m_initMsgString = VWResource.s_trackerDataFailedToInitialize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initialize() throws Exception {
        if (this.m_initState == 7 || this.m_initState == 6 || this.m_bInitializing) {
            return;
        }
        this.m_bInitializing = true;
        try {
            Object object = this.m_semaphore;
            synchronized (object) {
                Object object2 = this.m_trackerMode;
                synchronized (object2) {
                    Object object3 = this.m_updatingInitMsg;
                    synchronized (object3) {
                        this.m_initMsgString = VWResource.s_fetchingWorkFromQueue;
                        this.m_initSubMsgString = null;
                        this.m_initState = 1;
                    }
                    VWWorkObject vwWorkObject = null;
                    vwWorkObject = this.fetchInitialWorkObject(this.m_queueName, this.m_wobNumber);
                    if (vwWorkObject != null) {
                        try {
                            vwWorkObject.getFieldValue("F_Occurrence");
                        }
                        catch (VWException e) {
                            this.m_b41Workflow = true;
                        }
                        this.m_initialWorkObject = vwWorkObject;
                        this.m_process = this.m_initialWorkObject.fetchProcess();
                        this.m_workflowNumber = this.m_initialWorkObject.getWorkflowNumber();
                        this.m_bTracker |= this.m_initialWorkObject.getIsTracker();
                        if (this.m_bTracker) {
                            this.m_initialTracker = this.m_initialWorkObject.getParticipantName();
                        }
                    } else {
                        throw new Exception(VWResource.s_failedToRetrieveWorkInQueue.toString(this.m_wobNumber, this.m_queueName, ""));
                    }
                    switch (this.m_preferredTrackerMode) {
                        case 1: {
                            this.m_bTracker = false;
                            break;
                        }
                        case 2: {
                            this.m_bTracker = true;
                        }
                    }
                    if (!this.m_bTracker && this.isCurrentUserATracker()) {
                        this.m_bTracker = true;
                    }
                    if (this.m_preferredTrackerMode == 0 && !this.m_bTracker && this.m_sessionInfo.isAllowedToRunAdministrationApp()) {
                        this.m_bTracker = true;
                    }
                }
                if (!this.m_initialWorkObject.getIsTracker()) {
                    this.m_initialStepId = this.m_initialWorkObject.getWorkOrderId();
                    Object obj = this.m_initialWorkObject.getFieldValue("F_InstrSheetId");
                    if (obj != null && obj instanceof Integer) {
                        this.m_initialMapId = (Integer)obj;
                    }
                }
                this.m_launchDate = this.m_initialWorkObject.getLaunchDate();
                this.m_originator = this.m_initialWorkObject.getOriginatorPx();
                this.m_name = this.m_workClassName = this.m_initialWorkObject.getWorkClassName();
                if (this.m_workClassName == null) {
                    throw new Exception(VWResource.s_failedToRetrieveWorkflowDefinition);
                }
                object2 = this.m_updatingInitMsg;
                synchronized (object2) {
                    this.m_initMsgString = VWResource.s_fetchingWorkflowDefinition;
                    this.m_initSubMsgString = null;
                    this.m_initState = 2;
                }
                if (this.m_bSync) {
                    this.wait();
                }
                if (this.m_bSync) {
                    this.m_semaphore.wait();
                }
                this.fetchWorkflowDefinition();
                if (this.m_bSync) {
                    this.wait();
                }
                if (this.m_bSync) {
                    this.m_semaphore.wait();
                }
                object2 = this.m_updatingInitMsg;
                synchronized (object2) {
                    this.m_initMsgString = VWResource.s_initializingMilestoneHistory;
                    this.m_initSubMsgString = null;
                    this.m_initState = 4;
                }
                if (this.m_bSync) {
                    this.wait();
                }
                if (this.m_bSync) {
                    this.m_semaphore.wait();
                }
                this.initMilestones();
                object2 = this.m_updatingInitMsg;
                synchronized (object2) {
                    this.m_initMsgString = VWResource.s_initializingStepHistory;
                    this.m_initSubMsgString = null;
                    this.m_initState = 4;
                }
                if (this.m_bSync) {
                    this.wait();
                }
                if (this.m_bSync) {
                    this.m_semaphore.wait();
                }
                this.initStepHistory();
                object2 = this.m_updatingInitMsg;
                synchronized (object2) {
                    this.m_initMsgString = VWResource.s_initializingRuntimeData;
                    this.m_initSubMsgString = null;
                    this.m_initState = 5;
                }
                if (this.m_bSync) {
                    this.wait();
                }
                if (this.m_bSync) {
                    this.m_semaphore.wait();
                }
                this.initWorkObjects();
                this.initExceptionWorkObjects();
                object2 = this.m_updatingInitMsg;
                synchronized (object2) {
                    this.m_initState = 6;
                    this.m_initSubMsgString = null;
                    this.m_initMsgString = VWResource.s_trackerDataInitialized;
                }
            }
        }
        catch (Exception ex) {
            Object object = this.m_updatingInitMsg;
            synchronized (object) {
                this.m_initState = 7;
                this.m_initMsgString = VWResource.s_trackerDataFailedToInitialize;
                this.m_initSubMsgString = ex.getLocalizedMessage();
            }
            VWDebug.logException(ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getInitMsgStrings() {
        while (true) {
            Object object = this.m_updatingInitMsg;
            synchronized (object) {
                String[] msgs = new String[2];
                String msg = this.m_initMsgString;
                if (msg != null) {
                    if (this.isInitializing()) {
                        this.m_initMsgString = null;
                    }
                    msgs[0] = msg;
                    msgs[1] = this.m_initSubMsgString;
                    return msgs;
                }
                if (!this.isInitializing()) {
                    return null;
                }
            }
            this.m_bSync = true;
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
            object = this.m_semaphore;
            synchronized (object) {
                this.m_bSync = false;
                this.m_semaphore.notifyAll();
            }
        }
    }

    public int getInitState() {
        return this.m_initState;
    }

    public boolean isInitializing() {
        return this.m_initState != 6 && this.m_initState != 7;
    }

    public VWWorkObject fetchInitialWorkObject(String queueName, String wobNumber) throws Exception {
        VWWorkObject vwWorkObject = null;
        VWQueue vwQueue = null;
        VWQueueQuery vwQueueQuery = null;
        Object[] values = new Object[]{wobNumber};
        int queryFlags = 99;
        try {
            vwQueue = VWDefaultSessionProxy.getQueue(queueName);
        }
        catch (VWException e) {
            VWDebug.logException(e);
            throw new Exception(VWResource.s_failedToAccessQueue.toString(queueName, e.getLocalizedMessage()));
        }
        try {
            vwQueueQuery = vwQueue.createQuery("F_WobNum", values, values, queryFlags, null, null, 1);
            vwWorkObject = (VWWorkObject)vwQueueQuery.next();
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            String s = ex.getLocalizedMessage();
            if (s == null) {
                s = "";
            }
            throw new Exception(VWResource.s_failedToRetrieveWorkInQueue.toString(wobNumber, queueName, s));
        }
        return vwWorkObject;
    }

    private VWWorkflowDefinition fetchWorkflowDefinition() throws Exception {
        if (this.m_workflowDefinition == null) {
            int i;
            if (this.m_process != null && this.m_workflowDefinition == null) {
                try {
                    this.m_workflowDefinition = this.m_process.fetchWorkflowDefinition(true);
                }
                catch (VWException ex) {
                    VWDebug.logException(ex);
                    this.m_workflowDefinition = null;
                }
            }
            if (this.m_workflowDefinition == null) {
                try {
                    Object obj = this.m_initialWorkObject.getFieldValue("F_SourceDoc");
                    if (obj != null && obj instanceof String) {
                        this.m_docSpec = (String)obj;
                    }
                }
                catch (VWException ex) {
                    VWDebug.logException(ex);
                    this.m_docSpec = null;
                }
                InputStream stream = null;
                try {
                    String[] names;
                    if (this.m_docSpec == null && (names = this.parseWorkClassName(this.m_workClassName)).length >= 3) {
                        this.m_docSpec = names[2];
                    }
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    throw ex;
                }
                IVWIDMDocument doc = (IVWIDMDocument)VWIDMBaseFactory.instance().getIDMItem(this.m_docSpec);
                if (doc != null) {
                    byte[] fileContents = doc.getContents(false);
                    stream = new ByteArrayInputStream(fileContents);
                }
                this.m_workflowDefinition = VWWorkflowDefinition.read(stream);
                stream.close();
            }
            this.m_tag = this.m_workflowDefinition.getTag();
            this.m_mainMapId = this.m_workflowDefinition.getMainMap().getMapId();
            VWMapDefinition mainMap = null;
            VWMapDefinition map = null;
            VWMapDefinition[] maps = this.m_workflowDefinition.getMaps();
            VWTrkMap trkMap = null;
            String mapName = null;
            String name = null;
            this.m_maps = new Vector();
            for (i = 0; i < maps.length; ++i) {
                map = maps[i];
                if (map == null) continue;
                if (map.getMapId() == this.m_mainMapId) {
                    mainMap = map;
                    continue;
                }
                int j = 0;
                mapName = map.getName();
                if (mapName != null) {
                    for (j = 0; j < this.m_maps.size() && ((name = (trkMap = (VWTrkMap)this.m_maps.elementAt(j)).getMapDefinition().getName()) == null || VWStringUtils.compareIgnoreCase(mapName, name) >= 0); ++j) {
                    }
                }
                this.m_maps.insertElementAt(new VWTrkMap(this, map, false), j);
            }
            if (mainMap != null) {
                this.m_mainMap = new VWTrkMap(this, mainMap, true);
                this.m_maps.insertElementAt(this.m_mainMap, 0);
            }
            for (i = 0; i < this.m_maps.size(); ++i) {
                ((VWTrkMap)this.m_maps.elementAt(i)).initStepDefinition();
            }
        }
        return this.m_workflowDefinition;
    }

    private void initMilestones() throws Exception {
        this.m_milestones = new Vector();
        VWMilestoneDefinition[] milestoneDefinitions = this.m_workflowDefinition.getMilestones();
        if (milestoneDefinitions != null) {
            for (int i = 0; i < milestoneDefinitions.length; ++i) {
                if (milestoneDefinitions[i] == null) continue;
                this.m_milestones.add(new VWTrkMilestone(this, milestoneDefinitions[i], i));
            }
        }
        try {
            VWProcess process = this.getProcess();
            if (process == null) {
                return;
            }
            VWWorkflowMilestones workflowMilestones = process.fetchReachedWorkflowMilestones(99);
            while (workflowMilestones.hasNext()) {
                int index;
                VWMilestoneElement milestone = workflowMilestones.next();
                if (milestone == null || (index = milestone.getMilestoneId()) < 0 || index >= this.m_milestones.size()) continue;
                ((VWTrkMilestone)this.m_milestones.elementAt(index)).addMilestoneElement(milestone);
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            throw new Exception(VWResource.s_failedToInitializeMilestoneHistory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStepHistory() throws Exception {
        try {
            for (int i = 0; i < this.m_maps.size(); ++i) {
                Object obj = this.m_maps.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkMap)) continue;
                VWTrkMap map = (VWTrkMap)obj;
                String name = map.getMapDefinition().getName();
                if (this.m_bSync) {
                    this.wait();
                }
                if (this.m_bSync) {
                    this.m_semaphore.wait();
                }
                Object object = this.m_updatingInitMsg;
                synchronized (object) {
                    this.m_initMsgString = VWResource.s_initializingStepHistoryForMap.toString(name);
                    this.m_initSubMsgString = null;
                    this.m_initState = 4;
                }
                map.initStepHistory();
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            throw new Exception(VWResource.s_failedToInitializeStepHistory);
        }
    }

    private void initWorkObjects() throws Exception {
        VWWorkObject vwWorkObject = null;
        Object participant = null;
        int stepId = 0;
        boolean bInitialWob = false;
        this.m_trackerWorkObjects.removeAllElements();
        this.m_initialWorkObject = null;
        this.m_rootWorkObject = null;
        try {
            this.m_process.resetFetch();
            while (this.m_process.hasNext()) {
                vwWorkObject = this.m_process.next();
                if (vwWorkObject == null) {
                    return;
                }
                String wobNumber = vwWorkObject.getWorkObjectNumber();
                if (VWStringUtils.compare(wobNumber, this.m_workflowNumber) == 0) {
                    this.m_rootWorkObject = vwWorkObject;
                }
                if (VWStringUtils.compare(wobNumber, this.m_wobNumber) == 0) {
                    this.m_initialWorkObject = vwWorkObject;
                    bInitialWob = true;
                } else {
                    bInitialWob = false;
                }
                Object obj = vwWorkObject.getFieldValue("F_InstrSheetId");
                int instrSheetId = -1;
                boolean bLocalMap = false;
                if (obj == null || !(obj instanceof Integer) || !(bLocalMap = this.isLocalMap(instrSheetId = ((Integer)obj).intValue())) && instrSheetId != -7) continue;
                obj = vwWorkObject.getFieldValue("F_QueueWPClassId");
                int queueId = -1;
                if (obj != null && obj instanceof Integer) {
                    queueId = (Integer)obj;
                }
                obj = vwWorkObject.getFieldValue("F_OperationId");
                int operationId = -1;
                if (obj != null && obj instanceof Integer) {
                    operationId = (Integer)obj;
                }
                if (operationId == -1 && queueId == -6 || operationId == 19 && queueId == -5) continue;
                if (instrSheetId == -7 && vwWorkObject.getIsTracker()) {
                    this.m_trackerWorkObjects.addElement(vwWorkObject);
                }
                if (!bLocalMap) continue;
                stepId = this.convertWorkOrderIdToStepId(vwWorkObject);
                String wobName = vwWorkObject.getWorkObjectNumber();
                VWTrkStep step = this.findStep(instrSheetId, stepId);
                if (step == null) continue;
                step.addWorkObject(new VWTrkWorkObject(this, vwWorkObject));
                if (!bInitialWob) continue;
                VWTrkStepOccurrence initialOccurrence = null;
                initialOccurrence = this.is41Workflow() ? step.getStepOccurrence(this.m_initialWorkObject.getDateReceived()) : step.findOccurrence(this.m_initialWorkObject);
                if (initialOccurrence == null) continue;
                step.setInitialOccurrenceIndex(initialOccurrence.getOccurrenceIndex());
            }
            this.m_trackerWorkObjects = this.sortVWWorkObjectList(this.m_trackerWorkObjects);
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
    }

    private VWTrkParticipant findAndLockWorkObjectToAddTracker() {
        for (int i = 0; i < this.m_maps.size(); ++i) {
            VWTrkMap map;
            Vector activeSteps;
            Object obj = this.m_maps.elementAt(i);
            if (obj == null || !(obj instanceof VWTrkMap) || (activeSteps = (map = (VWTrkMap)obj).getActiveSteps()) == null) continue;
            for (int k = 0; k < activeSteps.size(); ++k) {
                obj = activeSteps.elementAt(k);
                if (obj == null || !(obj instanceof VWTrkStep)) continue;
                VWTrkStep step = (VWTrkStep)obj;
                Vector occurrences = ((VWTrkStep)obj).getActiveOccurrences();
                if (occurrences == null || occurrences.size() <= 0) continue;
                for (int index = 0; index < occurrences.size(); ++index) {
                    VWTrkStepOccurrence occurrence = (VWTrkStepOccurrence)occurrences.elementAt(index);
                    Vector participants = occurrence.getActiveParticipants();
                    if (participants == null) continue;
                    for (int j = 0; j < participants.size(); ++j) {
                        VWTrkParticipant participant;
                        obj = participants.elementAt(j);
                        if (obj == null || !(obj instanceof VWTrkParticipant) || !(participant = (VWTrkParticipant)obj).isActive() || participant.isLockedByCurrentUser() || participant.isLockedByOther() || !participant.lockWork()) continue;
                        return participant;
                    }
                }
            }
        }
        return null;
    }

    public void addTrackers(Vector trackersToAdd) throws Exception {
        if (trackersToAdd.size() > 0 && this.m_initialWorkObject != null) {
            if (this.m_initialTracker != null && this.m_bRemoveInitialTracker) {
                for (int i = 0; i < trackersToAdd.size(); ++i) {
                    VWParticipant p = (VWParticipant)trackersToAdd.elementAt(i);
                    if (p == null || !VWStringUtils.compareUsers(this.m_initialTracker, p.getParticipantName())) continue;
                    this.m_bRemoveInitialTracker = false;
                    trackersToAdd.removeElementAt(i);
                    break;
                }
            }
            if (trackersToAdd.size() > 0) {
                VWParticipant[] trackers = new VWParticipant[trackersToAdd.size()];
                for (int i = 0; i < trackersToAdd.size(); ++i) {
                    trackers[i] = (VWParticipant)trackersToAdd.elementAt(i);
                }
                if (this.m_initialWorkObject != null & this.m_initialWorkObject.getIsTracker()) {
                    this.m_initialWorkObject.doLock(true);
                    this.m_initialWorkObject.setFieldValue("F_Trackers", trackers, false);
                    this.m_initialWorkObject.doSave(true);
                    return;
                }
                if (this.m_trackerWorkObjects != null) {
                    VWTrkWorkObject trkWob;
                    VWWorkObject wob;
                    for (int i = 0; i < this.m_trackerWorkObjects.size(); ++i) {
                        Object obj = this.m_trackerWorkObjects.elementAt(i);
                        if (obj == null || !(obj instanceof VWWorkObject)) continue;
                        wob = (VWWorkObject)obj;
                        try {
                            wob.doLock(true);
                            wob.setFieldValue("F_Trackers", trackers, false);
                            wob.doSave(true);
                            return;
                        }
                        catch (VWException ex) {
                            // empty catch block
                        }
                    }
                    VWTrkParticipant participant = this.findAndLockWorkObjectToAddTracker();
                    if (participant != null && participant.isLockedByCurrentUser() && (trkWob = participant.getParticipantWorkObject()) != null && trkWob.isLockedByCurrentUser() && (wob = trkWob.getVWWorkObject()) != null) {
                        wob.setFieldValue("F_Trackers", trackers, false);
                        participant.unlockWork(true, false);
                        return;
                    }
                }
                throw new Exception(VWResource.s_failedToAddTrackers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        try {
            if (this.m_bRemoveInitialTracker && this.m_initialWorkObject != null && this.m_initialWorkObject.getIsTracker()) {
                this.m_initialWorkObject.doLock(false);
                this.m_initialWorkObject.doTerminate();
            }
        }
        catch (VWException vWException) {
        }
        finally {
            this.removeReferences();
        }
    }

    public void disgardChanges() {
        if (this.m_maps == null) {
            return;
        }
        Cursor currentCursor = null;
        if (this.m_mainContainer != null) {
            currentCursor = this.m_mainContainer.getCursor();
            this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(3));
        }
        this.m_stepsChanged = new Vector();
        Vector stepsChanged = null;
        Object obj = null;
        VWTrkMap map = null;
        for (int i = 0; i < this.m_maps.size(); ++i) {
            obj = this.m_maps.elementAt(i);
            if (obj == null || !(obj instanceof VWTrkMap) || (stepsChanged = (map = (VWTrkMap)obj).getAlteredSteps()) == null) continue;
            this.m_stepsChanged.addAll(stepsChanged);
        }
        if (this.m_stepsChanged.size() > 0) {
            this.refresh(this.m_stepsChanged, false);
            this.m_propertyChangeType = 704;
        }
        if (this.m_mainContainer != null) {
            this.m_mainContainer.setCursor(currentCursor);
        }
    }

    public VWTrkRoute findRoute(int routeId) {
        if (this.m_selectedMap != null) {
            return this.m_selectedMap.findRoute(routeId);
        }
        return null;
    }

    public VWTrkStep findStep(int mapId, int stepId) {
        if (this.m_maps.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.m_maps.size(); ++i) {
            VWTrkMap map;
            Object obj = this.m_maps.elementAt(i);
            if (obj == null || !(obj instanceof VWTrkMap) || (map = (VWTrkMap)obj).getMapId() != mapId) continue;
            return map.findStep(stepId);
        }
        return null;
    }

    public VWTrkStep findStep(int stepId) {
        if (this.m_selectedMap != null) {
            return this.m_selectedMap.findStep(stepId);
        }
        return null;
    }

    public VWTrkMilestone findMilestone(int id) {
        if (this.m_milestones != null) {
            for (int i = 0; i < this.m_milestones.size(); ++i) {
                Object obj = this.m_milestones.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkMilestone) || id != ((VWTrkMilestone)obj).getId()) continue;
                return (VWTrkMilestone)obj;
            }
        }
        return null;
    }

    public Vector getActiveSteps() {
        if (this.m_maps.size() == 0) {
            return null;
        }
        Vector activeSteps = new Vector();
        for (int i = 0; i < this.m_maps.size(); ++i) {
            VWTrkMap map;
            Vector moreActiveSteps;
            Object obj = this.m_maps.elementAt(i);
            if (obj == null || !(obj instanceof VWTrkMap) || (moreActiveSteps = (map = (VWTrkMap)obj).getActiveSteps()) == null || moreActiveSteps.size() <= 0) continue;
            activeSteps.addAll(moreActiveSteps);
        }
        if (activeSteps.size() > 0) {
            return activeSteps;
        }
        return null;
    }

    public boolean getCanManageTrackers() {
        return this.m_initialWorkObject != null;
    }

    public int getCurrentStepId() {
        return this.m_initialStepId;
    }

    public VWParticipant getCurrentUser() {
        try {
            VWUserInfo userInfo;
            if (this.m_currentUser == null && (userInfo = VWDefaultSessionProxy.fetchCurrentUserInfo()) != null) {
                this.m_currentUser = userInfo.getNamePx();
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
        return this.m_currentUser;
    }

    public String getDescription() {
        return this.m_workflowDefinition.getDescription();
    }

    public VWFieldDefinition getFieldDefinition(String name) {
        try {
            if (this.m_fieldDefinitions == null) {
                this.m_fieldDefinitions = this.m_workflowDefinition.getFields();
            }
            for (int i = 0; i < this.m_fieldDefinitions.length; ++i) {
                if (VWStringUtils.compare(name, this.m_fieldDefinitions[i].getName()) != 0) continue;
                return this.m_fieldDefinitions[i];
            }
        }
        catch (VWException vWException) {
            // empty catch block
        }
        return null;
    }

    public int getInitialMapId() {
        return this.m_initialMapId;
    }

    public int getInitialStepId() {
        return this.m_initialStepId;
    }

    public VWWorkObject getInitialWorkObject() {
        return this.m_initialWorkObject;
    }

    public Vector getItemsChanged() {
        switch (this.m_propertyChangeType) {
            case 704: 
            case 705: {
                return this.m_stepsChanged;
            }
            case 710: {
                return this.m_trackerWorkObjects;
            }
        }
        return null;
    }

    public Date getLaunchDate() {
        return this.m_launchDate;
    }

    public Vector getMilestones() {
        return this.m_milestones;
    }

    public Vector getMaps() {
        return this.m_maps;
    }

    public VWTrkMap getMap(String mapName) {
        if (mapName != null && this.m_maps != null && this.m_maps.size() > 0) {
            Object map = null;
            for (int i = 0; i < this.m_maps.size(); ++i) {
                String name;
                Object obj = this.m_maps.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkMap) || (name = ((VWTrkMap)obj).getMapName()) == null || VWStringUtils.compare(name, mapName) != 0) continue;
                return (VWTrkMap)obj;
            }
        }
        return null;
    }

    public VWTrkMap getMap(int mapId) {
        if (this.m_maps != null && this.m_maps.size() > 0) {
            Object map = null;
            for (int i = 0; i < this.m_maps.size(); ++i) {
                Object obj = this.m_maps.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkMap) || ((VWTrkMap)obj).getMapId() != mapId) continue;
                return (VWTrkMap)obj;
            }
        }
        return null;
    }

    public boolean getNeedRefresh() {
        return this.m_bNeedRefresh;
    }

    public VWParticipant getOriginator() {
        return this.m_originator;
    }

    public VWProcess getProcess() {
        return this.m_process;
    }

    public Vector getRouteCollection() {
        if (this.m_maps.size() == 0) {
            return null;
        }
        Vector routes = new Vector();
        for (int i = 0; i < this.m_maps.size(); ++i) {
            Object obj = this.m_maps.elementAt(i);
            if (obj == null || !(obj instanceof VWTrkMap)) continue;
            VWTrkMap map = (VWTrkMap)obj;
            routes.addAll(map.getRouteCollection());
        }
        if (routes.size() > 0) {
            return routes;
        }
        return null;
    }

    public VWTrkMap getSelectedMap() {
        return this.m_selectedMap;
    }

    public Vector getSelectedSteps() {
        if (this.m_selectedMap != null) {
            return this.m_selectedMap.getSelectedSteps();
        }
        return null;
    }

    public VWStatusDetailsDialog getStatusDetailsDialog() {
        return this.m_statusDetailsDialog;
    }

    public VWInformationStackDialog getInformationStackDialog() {
        return this.m_informationStackDialog;
    }

    public Vector getSelectedMapStepCollection() {
        VWTrkMap map = this.getSelectedMap();
        if (map == null) {
            return null;
        }
        return map.getStepCollection();
    }

    public Vector getStepCollection(int mapId) {
        if (this.m_maps.size() == 0) {
            return null;
        }
        Vector steps = new Vector();
        for (int i = 0; i < this.m_maps.size(); ++i) {
            VWTrkMap map;
            Object obj = this.m_maps.elementAt(i);
            if (obj == null || !(obj instanceof VWTrkMap) || mapId != (map = (VWTrkMap)obj).getMapId()) continue;
            steps.addAll(map.getStepCollection());
            break;
        }
        if (steps.size() > 0) {
            return steps;
        }
        return null;
    }

    public Vector getMapStepCollection(int mapId) {
        if (this.m_maps.size() == 0) {
            return null;
        }
        Vector steps = new Vector();
        for (int i = 0; i < this.m_maps.size(); ++i) {
            VWTrkMap map;
            Object obj = this.m_maps.elementAt(i);
            if (obj == null || !(obj instanceof VWTrkMap) || mapId != (map = (VWTrkMap)obj).getMapId()) continue;
            steps.addAll(map.getStepCollection());
            break;
        }
        if (steps.size() > 0) {
            return steps;
        }
        return null;
    }

    public Vector getStepCollection() {
        if (this.m_maps.size() == 0) {
            return null;
        }
        Vector steps = new Vector();
        for (int i = 0; i < this.m_maps.size(); ++i) {
            Object obj = this.m_maps.elementAt(i);
            if (obj == null || !(obj instanceof VWTrkMap)) continue;
            VWTrkMap map = (VWTrkMap)obj;
            steps.addAll(map.getStepCollection());
        }
        if (steps.size() > 0) {
            return steps;
        }
        return null;
    }

    public VWTrkLaunchStep getLaunchStep() {
        if (this.m_mainMap != null) {
            return this.m_mainMap.getLaunchStep();
        }
        return null;
    }

    public String getSubject() {
        if (this.m_subject == null) {
            if (this.m_initialWorkObject != null) {
                try {
                    this.m_subject = this.m_initialWorkObject.getSubject();
                }
                catch (VWException ex) {
                    this.m_subject = null;
                    VWDebug.logException(ex);
                }
            }
            if (this.m_subject == null && this.m_workflowDefinition != null) {
                this.m_subject = this.m_workflowDefinition.getSubject();
            }
        }
        return this.m_subject;
    }

    public String getBaseWorkClassName() {
        if (this.m_baseWorkClass == null && this.m_workflowDefinition != null) {
            this.m_baseWorkClass = this.m_workflowDefinition.getBaseWorkClassName();
        }
        return this.m_baseWorkClass;
    }

    public String getWorkflowName() {
        return this.m_name;
    }

    public String getTag() {
        return this.m_tag;
    }

    public String getRosterName() {
        try {
            if (this.m_rosterName == null && this.m_process != null) {
                this.m_rosterName = this.m_process.getRosterName();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_rosterName;
    }

    public String getEventLogName() {
        try {
            if (this.m_eventLogName == null && this.m_process != null) {
                this.m_eventLogName = this.m_process.getEventLogName();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_eventLogName;
    }

    public Vector getTrackerList() {
        if (this.m_bRemoveInitialTracker) {
            Vector v = (Vector)this.m_trackerWorkObjects.clone();
            for (int i = 0; i < v.size(); ++i) {
                Object obj = v.elementAt(i);
                if (!(obj instanceof VWWorkObject)) continue;
                VWWorkObject wob = (VWWorkObject)obj;
                try {
                    if (VWStringUtils.compare(this.m_wobNumber, wob.getWorkObjectNumber()) != 0) continue;
                    v.removeElementAt(i);
                    break;
                }
                catch (VWException ex) {
                    VWDebug.logException(ex);
                }
            }
            return v;
        }
        return (Vector)this.m_trackerWorkObjects.clone();
    }

    public Vector getNoDuplicateTrackerList() {
        Vector trackerObjects = (Vector)this.getTrackerList().clone();
        Vector returnTrackerList = new Vector();
        for (int i = 0; i < trackerObjects.size(); ++i) {
            Object obj = trackerObjects.elementAt(i);
            if (!(obj instanceof VWWorkObject)) continue;
            try {
                VWWorkObject tracker = (VWWorkObject)obj;
                VWParticipant participant = tracker.getParticipantNamePx();
                boolean bDuplicate = false;
                for (int j = 0; j < returnTrackerList.size(); ++j) {
                    if (returnTrackerList.elementAt(j) == null || VWStringUtils.compare(participant.getParticipantName(), ((VWWorkObject)returnTrackerList.elementAt(j)).getParticipantNamePx().getParticipantName()) != 0) continue;
                    bDuplicate = true;
                    break;
                }
                if (bDuplicate) continue;
                returnTrackerList.addElement(obj);
                continue;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        return returnTrackerList;
    }

    public Date getWorkflowDeadline() throws VWException {
        VWException exception = null;
        try {
            if (this.m_initialWorkObject != null && this.isTracker()) {
                return this.m_initialWorkObject.getDeadline();
            }
        }
        catch (VWException ex) {
            exception = ex;
            VWDebug.logException(ex);
        }
        if (this.m_trackerWorkObjects != null && this.m_trackerWorkObjects.size() > 0) {
            for (int i = 0; i < this.m_trackerWorkObjects.size(); ++i) {
                Object obj = this.m_trackerWorkObjects.elementAt(i);
                if (obj == null || !(obj instanceof VWWorkObject)) continue;
                VWWorkObject wob = (VWWorkObject)obj;
                try {
                    return wob.getDeadline();
                }
                catch (VWException e) {
                    if (exception == null) {
                        exception = e;
                    }
                    VWDebug.logException(e);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
        return null;
    }

    public VWWorkflowDefinition getWorkflowDefinition() {
        return this.m_workflowDefinition;
    }

    public int getWorkflowOverdue() throws VWException {
        VWException exception = null;
        try {
            if (this.m_initialWorkObject != null && this.isTracker()) {
                return this.m_initialWorkObject.getOverdue();
            }
        }
        catch (VWException ex) {
            exception = ex;
            VWDebug.logException(ex);
        }
        if (this.m_trackerWorkObjects != null && this.m_trackerWorkObjects.size() > 0) {
            for (int i = 0; i < this.m_trackerWorkObjects.size(); ++i) {
                Object obj = this.m_trackerWorkObjects.elementAt(i);
                if (!(obj instanceof VWWorkObject)) continue;
                VWWorkObject wob = (VWWorkObject)obj;
                try {
                    return wob.getOverdue();
                }
                catch (VWException e) {
                    if (exception == null) {
                        exception = e;
                    }
                    VWDebug.logException(e);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
        return 0;
    }

    public boolean isWorkflowCompleted() {
        try {
            return this.getWorkflowOverdue() == 3;
        }
        catch (VWException vWException) {
            return false;
        }
    }

    public Date getWorkflowCompletionDate() {
        if (!this.isWorkflowCompleted()) {
            return null;
        }
        if (this.m_completionDate != null) {
            return this.m_completionDate;
        }
        VWTrkMap map = null;
        Object obj = null;
        for (int i = 0; i < this.m_maps.size(); ++i) {
            obj = this.m_maps.elementAt(i);
            if (obj == null || !(obj instanceof VWTrkMap)) continue;
            map = obj;
            Vector steps = map.getSteps();
            for (int j = 0; j < steps.size(); ++j) {
                VWTrkStep step;
                Vector occurrences;
                obj = steps.elementAt(j);
                if (obj == null || !(obj instanceof VWTrkStep) || (occurrences = (step = (VWTrkStep)obj).getOccurrenceCollection()) == null) continue;
                for (int k = 0; k < occurrences.size(); ++k) {
                    if (occurrences.elementAt(k) == null || !(occurrences.elementAt(k) instanceof VWTrkStepOccurrence)) continue;
                    VWTrkStepOccurrence occurrence = (VWTrkStepOccurrence)occurrences.elementAt(k);
                    Date date = ((VWTrkStepOccurrence)occurrences.elementAt(k)).getCompletionDate();
                    if (date == null) continue;
                    if (this.m_completionDate == null) {
                        this.m_completionDate = date;
                        continue;
                    }
                    if (date.compareTo(this.m_completionDate) <= 0) continue;
                    this.m_completionDate = date;
                }
            }
        }
        return this.m_completionDate;
    }

    public boolean isAltered() {
        if (this.m_maps.size() == 0) {
            return false;
        }
        boolean bAltered = false;
        for (int i = 0; i < this.m_maps.size(); ++i) {
            Object obj = this.m_maps.elementAt(i);
            if (obj == null || !(obj instanceof VWTrkMap)) continue;
            VWTrkMap map = (VWTrkMap)obj;
            bAltered |= map.isAltered();
        }
        return bAltered;
    }

    public boolean isLaunchStep(VWMapNode node) {
        if (this.m_workflowDefinition == null) {
            return false;
        }
        if (this.m_launchStep == null) {
            try {
                this.m_launchStep = this.m_workflowDefinition.getMainMap().getStartStep();
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
                return false;
            }
        }
        return this.m_launchStep == node;
    }

    public boolean isLaunchStep(VWTrkStep step) {
        if (step != null) {
            return this.isLaunchStep(step.getStepDefinition());
        }
        return false;
    }

    public boolean isLockedByCurrentUser() {
        if (this.m_maps.size() == 0) {
            return false;
        }
        boolean bLockedByCurrentUser = false;
        for (int i = 0; i < this.m_maps.size(); ++i) {
            Object obj = this.m_maps.elementAt(i);
            if (obj == null || !(obj instanceof VWTrkMap)) continue;
            VWTrkMap map = (VWTrkMap)obj;
            bLockedByCurrentUser |= map.isLockedByCurrentUser();
        }
        return bLockedByCurrentUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTracker() {
        Object object = this.m_trackerMode;
        synchronized (object) {
            return this.m_bTracker;
        }
    }

    public boolean is41Workflow() {
        return this.m_b41Workflow;
    }

    public void setPreferredTrackerMode(int preferredTrackerMode) {
        this.m_preferredTrackerMode = preferredTrackerMode;
    }

    public void refresh(boolean bSave) {
        Cursor currentCursor = null;
        if (this.m_mainContainer != null) {
            currentCursor = this.m_mainContainer.getCursor();
            this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(3));
        }
        try {
            this.m_bRefreshing = true;
            this.setNeedRefresh(false);
            this.removeAllWorkObjects(bSave);
            this.initMilestones();
            this.initStepHistory();
            this.initWorkObjects();
            this.initExceptionWorkObjects();
            this.m_propertyChangeType = 705;
            if (this.m_maps.size() != 0) {
                this.m_stepsChanged = new Vector();
                for (int i = 0; i < this.m_maps.size(); ++i) {
                    Object obj = this.m_maps.elementAt(i);
                    if (obj == null || !(obj instanceof VWTrkMap)) continue;
                    VWTrkMap map = (VWTrkMap)obj;
                    this.m_stepsChanged.addAll(map.getSteps());
                }
            }
            this.notifyPropertyChange();
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
        catch (Exception e) {
            VWDebug.logException(e);
        }
        this.m_bRefreshing = false;
        if (this.m_mainContainer != null) {
            this.m_mainContainer.setCursor(currentCursor);
        }
    }

    public void refresh(Vector stepsToRefresh, boolean bSave) {
        if (this.m_process == null) {
            return;
        }
        if (stepsToRefresh == null || stepsToRefresh.size() == 0) {
            return;
        }
        Cursor currentCursor = null;
        if (this.m_mainContainer != null) {
            currentCursor = this.m_mainContainer.getCursor();
            this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(3));
        }
        VWTrkStep step = null;
        VWWorkObject vwWorkObject = null;
        for (int i = 0; i < stepsToRefresh.size(); ++i) {
            step = (VWTrkStep)stepsToRefresh.elementAt(i);
            step.removeAllWorkObjects(bSave);
            this.updateStepHistory(step);
        }
        try {
            this.initMilestones();
            this.initExceptionWorkObjects();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.m_process.resetFetch();
            while (this.m_process.hasNext() && (vwWorkObject = this.m_process.next()) != null) {
                VWTrkMap map;
                String queueName = vwWorkObject.getCurrentQueueName();
                if (queueName.length() > 5) {
                    queueName = queueName.substring(0, 5);
                }
                if ((queueName = queueName.toLowerCase(Locale.ENGLISH)).length() == 5 && VWStringUtils.compare(queueName, "delay") == 0 || vwWorkObject.getIsTracker()) continue;
                int stepId = vwWorkObject.getWorkOrderId();
                String mapName = vwWorkObject.getInstructionSheetName();
                if (mapName == null || (map = this.getMap(mapName)) == null || (step = this.findStep(map.getMapId(), stepId)) == null || !stepsToRefresh.contains(step)) continue;
                step.addWorkObject(new VWTrkWorkObject(this, vwWorkObject));
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
        this.m_propertyChangeType = 704;
        this.m_stepsChanged = stepsToRefresh;
        this.notifyPropertyChange();
        if (this.m_mainContainer != null) {
            this.m_mainContainer.setCursor(currentCursor);
        }
    }

    public void refreshTrackerList() throws VWException {
        VWWorkObject vwWorkObject = null;
        Object participant = null;
        try {
            this.m_process.resetFetch();
            this.m_trackerWorkObjects.removeAllElements();
            this.m_initialWorkObject = null;
            this.m_rootWorkObject = null;
            while (this.m_process.hasNext()) {
                int queueId;
                Object obj;
                vwWorkObject = this.m_process.next();
                if (vwWorkObject == null) {
                    return;
                }
                String wobNumber = vwWorkObject.getWorkObjectNumber();
                if (VWStringUtils.compare(wobNumber, this.m_workflowNumber) == 0) {
                    this.m_rootWorkObject = vwWorkObject;
                }
                if (VWStringUtils.compare(wobNumber, this.m_wobNumber) == 0) {
                    this.m_initialWorkObject = vwWorkObject;
                }
                if ((obj = vwWorkObject.getFieldValue("F_QueueWPClassId")) != null && obj instanceof Integer && ((queueId = ((Integer)obj).intValue()) == -6 || queueId == -5)) continue;
                obj = vwWorkObject.getFieldValue("F_InstrSheetId");
                int instrSheetId = -1;
                if (obj != null && obj instanceof Integer) {
                    instrSheetId = (Integer)obj;
                }
                if (instrSheetId != -7 || !vwWorkObject.getIsTracker()) continue;
                this.m_trackerWorkObjects.addElement(vwWorkObject);
            }
            this.m_trackerWorkObjects = this.sortVWWorkObjectList(this.m_trackerWorkObjects);
            this.m_propertyChangeType = 710;
            this.notifyPropertyChange();
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
    }

    private void removeAllWorkObjects(boolean bSave) {
        if (this.m_trackerWorkObjects != null) {
            this.m_trackerWorkObjects.removeAllElements();
            this.m_trackerWorkObjects = new Vector();
        }
        if (this.m_maps != null) {
            Object obj = null;
            VWTrkMap map = null;
            for (int i = 0; i < this.m_maps.size(); ++i) {
                obj = this.m_maps.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkMap)) continue;
                map = obj;
                map.removeAllWorkObjects(bSave);
            }
        }
        System.gc();
        System.runFinalization();
    }

    private void removeHistory() {
        if (this.m_maps != null) {
            Object obj = null;
            VWTrkMap map = null;
            for (int i = 0; i < this.m_maps.size(); ++i) {
                obj = this.m_maps.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkMap)) continue;
                map = obj;
                map.removeHistory();
            }
        }
        System.gc();
        System.runFinalization();
    }

    public Exception[] removeTrackers(Vector trackersToRemove) {
        if (trackersToRemove == null || trackersToRemove.size() == 0) {
            return null;
        }
        Exception[] exceptions = new Exception[trackersToRemove.size()];
        int index = 0;
        for (int i = 0; i < trackersToRemove.size(); ++i) {
            VWWorkObject wob = (VWWorkObject)trackersToRemove.elementAt(i);
            String name = null;
            if (wob == null) continue;
            try {
                name = wob.getParticipantName();
                if (this.m_initialTracker != null && VWStringUtils.compareUsers(this.m_initialTracker, name)) {
                    this.m_bRemoveInitialTracker = true;
                    continue;
                }
                try {
                    wob.doLock(false);
                    wob.doTerminate();
                }
                catch (VWException ex) {
                    exceptions[index++] = new Exception(VWResource.s_unableToRemoveTracker.toString(name, ex.getLocalizedMessage()));
                }
                continue;
            }
            catch (VWException ex) {
                exceptions[index++] = new Exception(ex.getLocalizedMessage());
            }
        }
        Exception[] exs = null;
        if (index > 0) {
            exs = new Exception[index];
            System.arraycopy(exceptions, 0, exs, 0, index);
        }
        return exs;
    }

    public void saveAllChanges() throws VWException {
        if (this.m_maps.size() == 0) {
            return;
        }
        Cursor currentCursor = null;
        if (this.m_mainContainer != null) {
            currentCursor = this.m_mainContainer.getCursor();
            this.m_mainContainer.setCursor(Cursor.getPredefinedCursor(3));
        }
        VWException exception = null;
        Object obj = null;
        VWTrkMap map = null;
        for (int i = 0; i < this.m_maps.size(); ++i) {
            obj = this.m_maps.elementAt(i);
            if (obj == null || !(obj instanceof VWTrkMap)) continue;
            map = obj;
            try {
                map.saveAllChanges();
                continue;
            }
            catch (VWException ex) {
                if (exception != null) continue;
                exception = ex;
            }
        }
        if (this.m_mainContainer != null) {
            this.m_mainContainer.setCursor(currentCursor);
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void setNeedRefresh(boolean bNeedRefresh) {
        if (bNeedRefresh && this.m_bRefreshing) {
            return;
        }
        this.m_bNeedRefresh = bNeedRefresh;
    }

    public void setSelectedMap(VWTrkMap map) {
        this.m_selectedMap = map;
    }

    public void setStatusDetailsDialog(VWStatusDetailsDialog dialog) {
        this.m_statusDetailsDialog = dialog;
    }

    public void setInformationStackDialog(VWInformationStackDialog dialog) {
        this.m_informationStackDialog = dialog;
    }

    private void updateStepHistory(VWTrkStep step) {
        if (step != null && step.getMap() != null) {
            step.getMap().updateStepHistory(step);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (this.m_selectedMap != null) {
            this.m_selectedMap.itemStateChanged(e);
        }
    }

    public void notifyPropertyChange() {
        switch (this.m_propertyChangeType) {
            case 704: 
            case 705: {
                if (this.m_stepsChanged == null) break;
                VWPropertyChangeNotifier.notifyPropertyChange(new VWPropertyChangeEvent(this, this.m_propertyChangeType));
                break;
            }
            case 710: {
                VWPropertyChangeNotifier.notifyPropertyChange(new VWPropertyChangeEvent(this, this.m_propertyChangeType));
            }
        }
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        Object obj = event.getSource();
        if (obj instanceof IVWPropertyChangeSource) {
            IVWPropertyChangeSource source = (IVWPropertyChangeSource)obj;
            int type = event.getID();
            switch (type) {
                case 703: 
                case 707: 
                case 708: {
                    this.refresh(false);
                }
            }
        }
    }

    private Vector sortVWWorkObjectList(Vector list) {
        if (list != null && list.size() > 1) {
            Vector<VWWorkObject> v = new Vector<VWWorkObject>();
            int index = 0;
            for (int i = 0; i < list.size(); ++i) {
                VWWorkObject wob = (VWWorkObject)list.elementAt(i);
                String name = null;
                try {
                    name = wob.getParticipantName();
                }
                catch (VWException ex) {
                    name = "";
                }
                for (index = 0; index < v.size(); ++index) {
                    String name1 = null;
                    try {
                        name1 = ((VWWorkObject)v.elementAt(index)).getParticipantName();
                    }
                    catch (VWException e) {
                        name1 = "";
                    }
                    if (VWStringUtils.compareIgnoreCase(name, name1) < 0) break;
                }
                v.insertElementAt(wob, index);
            }
            list = v;
        }
        return list;
    }

    static Vector sortSteps(Vector list) {
        if (list != null && list.size() > 1) {
            Vector<VWTrkStep> v = new Vector<VWTrkStep>();
            int index = 0;
            for (int i = 0; i < list.size(); ++i) {
                VWTrkStep step = (VWTrkStep)list.elementAt(i);
                String name = step.getStepName();
                for (index = 0; index < v.size(); ++index) {
                    String name1 = ((VWTrkStep)v.elementAt(index)).getStepName();
                    if (name != null && name1 != null && VWStringUtils.compareIgnoreCase(name, name1) < 0) break;
                }
                v.insertElementAt(step, index);
            }
            list = v;
        }
        return list;
    }

    static Vector sortRoutes(Vector list) {
        if (list != null && list.size() > 1) {
            Vector<VWTrkRoute> v = new Vector<VWTrkRoute>();
            int index = 0;
            for (int i = 0; i < list.size(); ++i) {
                VWTrkRoute route = (VWTrkRoute)list.elementAt(i);
                String name = route.getRouteName();
                if (name != null) {
                    String name1;
                    for (index = 0; index < v.size() && ((name1 = ((VWTrkRoute)v.elementAt(index)).getRouteName()) == null || VWStringUtils.compareIgnoreCase(name, name1) >= 0); ++index) {
                    }
                }
                v.insertElementAt(route, index);
            }
            list = v;
        }
        return list;
    }

    private String[] parseWorkClassName(String workClassName) {
        char wcnameSepearotr = '#';
        char[] delimiters = new char[]{wcnameSepearotr};
        String docSpec = null;
        String prefix = null;
        String name = null;
        int count = 0;
        String[] tokens = new String[3];
        if (workClassName != null && workClassName.length() > 0) {
            String str = null;
            if (workClassName.charAt(0) == '\"') {
                workClassName = str = String.copyValueOf(workClassName.toCharArray(), 1, workClassName.length() - 1);
            }
            if (workClassName.length() > 0 && workClassName.endsWith("\"")) {
                workClassName = str = String.copyValueOf(workClassName.toCharArray(), 0, workClassName.length() - 1);
            }
            if (VWStringUtils.compare(workClassName, "WorkObjectEx") != 0) {
                int i;
                int j = 0;
                for (i = 0; i < workClassName.length(); ++i) {
                    if (workClassName.charAt(i) != wcnameSepearotr) continue;
                    if (i != j && count < 3) {
                        tokens[count] = String.copyValueOf(workClassName.toCharArray(), j, i - j);
                    }
                    ++count;
                    j = i + 1;
                }
                if (i != j && count < 3) {
                    tokens[count] = String.copyValueOf(workClassName.toCharArray(), j, i - j);
                }
                if (count <= 1 && tokens[0] != null) {
                    docSpec = tokens[0];
                    if (count == 1) {
                        name = tokens[1];
                    }
                } else if (count >= 2) {
                    prefix = tokens[0];
                    name = tokens[1];
                    docSpec = tokens[2];
                }
            } else {
                prefix = "";
                name = workClassName;
                docSpec = "";
            }
        }
        String[] retStrings = new String[]{prefix, name, docSpec};
        return retStrings;
    }

    private boolean isLocalMap(int mapId) {
        if (mapId >= 0) {
            return true;
        }
        if (this.m_maps == null) {
            return false;
        }
        for (int i = 0; i < this.m_maps.size(); ++i) {
            Object obj = this.m_maps.elementAt(i);
            if (obj == null || !(obj instanceof VWTrkMap) || ((VWTrkMap)obj).getMapId() != mapId) continue;
            return true;
        }
        return false;
    }

    public void removeReferences() {
        Object obj;
        int i;
        this.m_initialWorkObject = null;
        this.m_mainContainer = null;
        this.m_process = null;
        Object m_workflowDefinition = null;
        if (this.m_maps != null) {
            for (i = 0; i < this.m_maps.size(); ++i) {
                obj = this.m_maps.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkMap)) continue;
                ((VWTrkMap)obj).removeReferences();
            }
            this.m_maps.removeAllElements();
            this.m_maps = null;
        }
        this.m_mainMap = null;
        this.m_selectedMap = null;
        if (this.m_milestones != null) {
            for (i = 0; i < this.m_milestones.size(); ++i) {
                obj = this.m_milestones.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkMilestone)) continue;
                ((VWTrkMilestone)obj).removeReferences();
            }
            this.m_milestones.removeAllElements();
            this.m_milestones = null;
        }
        if (this.m_fieldDefinitions != null) {
            for (i = 0; i < this.m_fieldDefinitions.length - 1; ++i) {
                this.m_fieldDefinitions[i] = null;
            }
            this.m_fieldDefinitions = null;
        }
        this.m_rootWorkObject = null;
        if (this.m_trackerWorkObjects != null) {
            this.m_trackerWorkObjects.removeAllElements();
            this.m_trackerWorkObjects = null;
        }
        this.m_launchStep = null;
        if (this.m_stepsChanged != null) {
            this.m_stepsChanged.removeAllElements();
            this.m_stepsChanged = null;
        }
        if (this.m_statusDetailsDialog != null) {
            this.m_statusDetailsDialog.removeReferences();
            this.m_statusDetailsDialog = null;
        }
        if (this.m_informationStackDialog != null) {
            this.m_informationStackDialog.removeReferences();
            this.m_informationStackDialog = null;
        }
    }

    private boolean isCurrentUserATracker() {
        VWRosterQuery rosterQuery = null;
        if (this.getCurrentUser() == null || this.m_process == null || this.m_workflowNumber == null) {
            return false;
        }
        try {
            VWRoster theRoster = null;
            String rosterName = null;
            VWSession serviceSession = VWDefaultSessionProxy.getSession();
            if (serviceSession == null) {
                return false;
            }
            rosterName = this.getRosterName();
            if (rosterName == null) {
                return false;
            }
            theRoster = serviceSession.getRoster(rosterName);
            if (theRoster == null) {
                return false;
            }
            theRoster.setBufferSize(100);
            boolean isIndex = false;
            boolean isExpField = false;
            String theIndexName = null;
            VWRosterDefinition rosterDef = theRoster.fetchRosterDefinition();
            if (rosterDef != null) {
                VWExposedFieldDefinition[] expFields = rosterDef.getFields();
                int fCount = 0;
                if (expFields != null) {
                    fCount = expFields.length;
                }
                for (int i = 0; i < fCount && !isExpField; ++i) {
                    String theFieldName = expFields[i].getAuthoredName();
                    if (theFieldName.compareTo("F_WorkFlowNumber") != 0) continue;
                    isExpField = true;
                }
                if (!isExpField) {
                    return false;
                }
                VWIndexDefinition[] indexDefs = rosterDef.getIndexes();
                int count = 0;
                if (indexDefs != null) {
                    count = indexDefs.length;
                }
                for (int i = 0; i < count && !isIndex; ++i) {
                    String[] theFieldNames = indexDefs[i].getAuthoredFieldNames();
                    if (theFieldNames[0].compareTo("F_WorkFlowNumber") != 0) continue;
                    theIndexName = indexDefs[i].getAuthoredName();
                    isIndex = true;
                }
            }
            if (isIndex) {
                Object[] minValues = new Object[]{this.m_workflowNumber};
                Object[] maxValues = new Object[]{this.m_workflowNumber};
                Object[] values = new Object[]{new Integer(1)};
                rosterQuery = theRoster.createQuery(theIndexName, minValues, maxValues, 96, "F_TrackerStatus = :x", values, 1);
            } else {
                Object[] values = new Object[]{this.m_workflowNumber, new Integer(1)};
                rosterQuery = theRoster.createQuery("", null, null, 0, "F_WorkFlowNumber = :x AND F_TrackerStatus = :y", values, 1);
            }
            while (rosterQuery.hasNext()) {
                VWParticipant participant;
                VWWorkObject vwWorkObject = (VWWorkObject)rosterQuery.next();
                if (vwWorkObject == null || (participant = vwWorkObject.getParticipantNamePx()) == null || !VWStringUtils.compareUsers(participant.getParticipantName(), this.m_currentUser.getParticipantName())) continue;
                return true;
            }
        }
        catch (VWException vWException) {
            // empty catch block
        }
        return false;
    }

    private void initExceptionWorkObjects() {
        this.m_exceptionWorkObjects = new Vector();
        VWProcess process = this.getProcess();
        if (process == null) {
            return;
        }
        VWWorkObject vwWorkObject = null;
        try {
            process.resetFetch();
            while (process.hasNext()) {
                vwWorkObject = process.next();
                if (vwWorkObject == null || VWStringUtils.compare(vwWorkObject.getLastErrorNumber(), "0") == 0) continue;
                this.m_exceptionWorkObjects.addElement(new VWTrkExceptionWO(vwWorkObject));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Vector getExceptionWO(int mapId, int stepId) {
        Vector<VWWorkObject> WOVector = new Vector<VWWorkObject>();
        block0: for (int i = 0; i < this.m_exceptionWorkObjects.size(); ++i) {
            VWTrkExceptionWO exceptionWO = (VWTrkExceptionWO)this.m_exceptionWorkObjects.elementAt(i);
            VWWorkObject vwWorkObject = exceptionWO.getWorkObject();
            VWReturnStackElement[] stackElements = exceptionWO.getStackElements();
            for (int j = 0; j < stackElements.length; ++j) {
                String errorNum = stackElements[j].getErrorNumber();
                if (VWStringUtils.compare(errorNum, "0") == 0 || stackElements[j].getMapId() != mapId || stackElements[j].getStepId() != stepId) continue;
                WOVector.addElement(vwWorkObject);
                continue block0;
            }
        }
        return WOVector;
    }

    protected int convertWorkOrderIdToStepId(VWWorkObject vwWorkObject) {
        int stepId;
        block5: {
            stepId = -1;
            try {
                if (vwWorkObject == null || this.m_maps == null) break block5;
                Object obj = vwWorkObject.getFieldValue("F_InstrSheetId");
                int instrSheetId = -1;
                if (obj != null && obj instanceof Integer) {
                    instrSheetId = (Integer)obj;
                }
                int workOrderId = vwWorkObject.getWorkOrderId();
                for (int i = 0; i < this.m_maps.size(); ++i) {
                    if (((VWTrkMap)this.m_maps.elementAt(i)).getMapId() != instrSheetId) continue;
                    VWMapDefinition mapDefinition = ((VWTrkMap)this.m_maps.elementAt(i)).getMapDefinition();
                    stepId = mapDefinition.getContainingStepId(workOrderId);
                    if (stepId == -1) {
                        stepId = workOrderId;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        return stepId;
    }

    private class VWTrkExceptionWO {
        VWWorkObject m_workObject = null;
        VWReturnStackElement[] m_stackElements = null;

        VWTrkExceptionWO(VWWorkObject workObject) {
            this.m_workObject = workObject;
            try {
                this.m_stackElements = workObject.fetchReturnStackElements();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }

        public VWWorkObject getWorkObject() {
            return this.m_workObject;
        }

        public VWReturnStackElement[] getStackElements() {
            return this.m_stackElements;
        }
    }
}

